//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "stereo.h"
#include "fscenanieuporzadkowana.h"
#include <stdlib.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 odczytaj_parametry();
}
//---------------------------------------------------------------------------
// Odczytaj parametry
void TForm1 :: odczytaj_parametry( void)
{
 try
 {
    sp = (StylPatrzenia)RadioGroup1 -> ItemIndex;
    if( sp == Anaglif)          //dla okularw kolor linii = kolor wypenienia
    {
        Lkolor1 = Lkolor2 = clRed;
        Rkolor1 = Rkolor2 = clAqua;
    }
    else
    {
        Lkolor1 = Rkolor1 = clBlack;
        Lkolor2 = Rkolor2 = clYellow;
    }
    baza = (double)TrackBar1 -> Position / 100.;
    obserwator.x = (double)TrackBar2 -> Position / 10.;
    obserwator.y = (double)TrackBar3 -> Position / 10.;
    obserwator.z = (double)TrackBar4 -> Position / 10.;
    ogniskowa = (double)TrackBar5 -> Position/100.;
 }
 catch(...)
 {
 }
}
//---------------------------------------------------------------------------
//  Wykrelenie kostki, rozpitej na podanych wierzchokach
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TStereo s( obserwator,         //pozycja obserwatora
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height, //okienko ekranowe
    baza,                       //odlego midzy oczami
    PaintBox1 -> Canvas,        //aparat graficzny
    sp,                         //styl projekcji stereo
    ogniskowa);                 //odlego oka od paszczyzny obrazowej
 TPunkt p(0, 0, 0);
 double bok = 3;

 srand( 1);                     //zainicjuj seri liczb pseudolosowych
 for( int i = 0; i < 10; i ++)
 {
    p.x = 5 - random( 10);
    p.y = 5 - random( 10);
    p.z = 5 - random( 10);
    plytka( &s, p, bok);
 }
}
//---------------------------------------------------------------------------
//  Pytka o rodku w 'p' i krawdzi 'bok', widziana w projekcji 's'
void TForm1 :: plytka( TStereo *s, TPunkt p, double bok)
{
 double b = bok/2;
 TPunkt p1(p.x+b,p.y+b,p.z), p2(p.x-b,p.y+b,p.z), p3(p.x-b,p.y-b,p.z), p4(p.x+b,p.y-b,p.z);

 s -> czworokat_stereo( p1, p2, p3, p4, Lkolor1, Rkolor1, Lkolor2, Rkolor2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Close();
}
//---------------------------------------------------------------------------

